﻿using Edu.Library.Mathematics;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Edu.Library.Logo
{
    public class Turtle
    {
        PointF _position;
        private float _alpha;
        private bool _penDown;
        private Color _penColor;
        private Color _backgroundColor;
        
        public List<Line> Lines { get; private set; }

        public Turtle()
        {
            _position = new PointF();
            _alpha = 0;
            _penDown = true;
            _backgroundColor = Color.White;
            _penColor = Color.Black;
            Hidden = false;
            Lines = new List<Line>();
        }

        public bool Hidden { get; private set; }

        public void HT()
        {
            Hidden = true;
        }

        public void ST()
        {
            Hidden = false;
        }

        // Right
        public void RT(double alpha = 90)
        {
            _alpha += (float)alpha;
        }

        // Left
        public void LT(double alpha = 90)
        {
            _alpha -= (float)alpha;
        }

        public void Towards(double x, double y)
        {
            var dx = x - _position.X;
            if (Math.Abs(dx) < 0.000001) dx = 0;
            var dy = y - _position.Y;
            if (Math.Abs(dy) < 0.000001) dy = 0;
            if (dx == 0 && dy == 0) return;

            var d = Math.Sqrt(dx * dx + dy * dy);

            if (dx != 0)
            {
                var sin = dx / d;
                var alphaRad = Math.Asin(sin);
                if (dy < 0) alphaRad = alphaRad + Math.Sign(alphaRad) * Math.PI / 2;
                _alpha = (float)EsyMath.RadToDeg(alphaRad);
                return;
            }

            if (dy != 0)
            {
                var cos = dy / d;
                var alphaRad = Math.Acos(cos);
                _alpha = (float)EsyMath.RadToDeg(alphaRad);
                return;
            }
        }

        public void SetX(double x)
        {
            _position.X = (float)x;
        }

        public void SetY(double y)
        {
            _position.Y = (float)y;
        }

        public void SetXY(double x, double y)
        {
            _position.X = (float)x;
            _position.Y = (float)y;
        }

        // Forward
        public Line FD(double pixels)
        {
            var alphaRad = EsyMath.DegToRad(_alpha);
            var fdX = pixels * Math.Sin(alphaRad);
            var fdY = pixels * Math.Cos(alphaRad);
            var newPosition = new PointF(_position.X + (float)fdX, _position.Y + (float)fdY);
            var line = new Line(_position, newPosition, _penColor);
            _position = newPosition;

            if (_penDown)
            {
                Lines.Add(line);
                return line;
            }
            return null;
        }

        // Back
        public Line BK(double pixels)
        {
            return FD(-pixels);
        }

        // Pen Up
        public void PU()
        {
            _penDown = false;
        }

        // Pen Down
        public void PD()
        {
            _penDown = true;
        }

        // Pen color
        public void PC(Color color)
        {
            _penColor = color;
        }

        // Background color
        public void BG(Color color)
        {
            _backgroundColor = color;
        }

        // Clear screen
        public void CS()
        {
            Lines = new List<Line>();
        }

        public void Home(bool resetDirection = true)
        {
            if (resetDirection)
            {
                _alpha = 0;
            }
            _position = new PointF();
        }

        public void Draw()
        {
            CS();
            Home();
        }

        public Color PenColor
        {
            get { return _penColor; }
        }

        public Color BgColor
        {
            get { return _backgroundColor; }
        }

        public double XCor
        {
            get { return _position.X; }
        }

        public double YCor
        {
            get { return _position.Y; }
        }

        public double AlphaCor
        {
            get { return _alpha; } 
        }

        public List<Line> GetTurtleLines(int size = 15, Color? color1 = null, Color? color2 = null)
        {
            if (color1 == null) color1 = Color.DarkGray;
            if (color2 == null) color2 = Color.Black;

            var turtle = this.Clone();

            turtle.PC(color1.Value);
            turtle.PD();

            turtle.LT();
            turtle.FD(size);
            turtle.RT(135);
            turtle.PC(color2.Value);
            turtle.FD(size * Math.Sqrt(2));

            turtle.LT(45);
            turtle.PU();
            turtle.BK(size);
            turtle.PD();
            turtle.PC(color1.Value);

            turtle.RT();
            turtle.FD(size);
            turtle.LT(135);
            turtle.PC(color2.Value);
            turtle.FD(size * Math.Sqrt(2));

            return turtle.Lines;
        }

        public Turtle Clone()
        {
            var clone = base.MemberwiseClone() as Turtle;
            return clone;
        }
    }
}
